<?php

namespace App\Models\Quota;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Distributions extends Model 
{

    protected $table = 'quota_distributions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('quota_id', 'city_id', 'district_id');
    protected $visible = array('quota_id', 'city_id', 'district_id');

    public function quota()
    {
        return $this->belongsTo('App\Models\Quota');
    }

    public function city()
    {
        return $this->belongsTo('App\Models\City');
    }

    public function district()
    {
        return $this->belongsTo('App\Models\District');
    }

}